#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct Edge {
	int from, to;
	int cap;
	int flow;
};

vector<Edge> edges;

vector<vi> g;

void add_edge(int from, int to) {
	Edge e1 = {from, to, 1, 0};
	g[from].push_back(edges.size());
	edges.push_back(e1);

	Edge e2 = {to, from, 0, 0};
	g[to].push_back(edges.size());
	edges.push_back(e2);
}

vi d;

int q[100000];

bool bfs(int n, int s, int t) {
	d.assign(n, -1);
	int qh = 0,  qt = 0;
	d[s] = 0;
	q[qt++] = s;
	while(qh != qt) {
		int v = q[qh++];
		for(int i = 0; i < g[v].size(); ++i) {
			int edgeId = g[v][i];
			Edge& edge = edges[edgeId];
			if(edge.flow == edge.cap)
				continue;
			if(d[edge.to] == -1) {
				q[qt++] = edge.to;
				d[edge.to] = d[v] + 1;
			}
		}
	}
	return d[t] != -1;
}

vi ptr;

int dfs(int v, int to) {
	if(v == to) {
		return 1;
	}
	for(int& i = ptr[v]; i < g[v].size(); ++i) {
		int edgeId = g[v][i];
		Edge& edge = edges[edgeId];
		if(edge.flow == edge.cap || d[edge.to] != d[v] + 1)
			continue;
		if(dfs(edge.to, to)) {
			edge.flow++;
			edges[edgeId ^ 1].flow--;
			return true;
		}
	}
	return false;
}

int dinic(int n, int s, int t) {
	int flow = 0;
	while(bfs(n, s, t)) {
		ptr.assign(n, 0);
		while(dfs(s, t)) {
			++flow;
		}
	}
	return flow;
}


vector<char> from_s;
vector<char> to_t;

void DFS(int v) {
	if(from_s[v])
		return;
	from_s[v] = true;
	for(int i = 0; i < g[v].size(); ++i) {
		int edgeId = g[v][i];
		Edge& edge = edges[edgeId];
		if(edge.flow == edge.cap)
			continue;
		DFS(edge.to);
	}
}

void DFS2(int v) {
	if(to_t[v])
		return;
	to_t[v] = true;
	for(int i = 0; i < g[v].size(); ++i) {
		int edgeId = g[v][i];
		Edge& edge = edges[edgeId];
		if(edge.flow || edge.cap)
			continue;
		DFS2(edge.to);
	}
}


void solve() {
	int n, m, s, t;
	cin >> n >> m >> s >> t;
	if(n == 0)
		exit(0);
	--s, --t;

	g.assign(n, vi());
	edges.clear();

	for(int i = 0; i < m; ++i) {
		int a, b;
		cin >> a >> b;
		--a, --b;
		add_edge(a, b);
	}

	int flow = dinic(n, s, t);
	int cnt = 0;

	from_s.assign(n, false);
	to_t.assign(n, false);
	DFS(s);
	DFS2(t);

	for(int i = 0; i < edges.size(); i += 2) {
		if(!edges[i].flow && from_s[edges[i].to] && to_t[edges[i].from]) {
			++cnt;
		}
	}

	if(cnt) {
		++flow;
	}

	
	cout << flow << ' ' << cnt << "\n";

}